/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.client.gui.components;

import com.nemonotfound.nemos.inventory.sorting.interfaces.GuiPosition;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSortButton
extends class_339 {
    protected final class_465<?> containerScreen;
    protected final Integer startIndex;
    protected final Integer endIndex;
    private final int x;
    private final int y;
    private final int xOffset;
    private final class_2561 buttonName;
    private final class_2561 shiftButtonName;
    protected boolean isShiftKeyDown = false;

    public AbstractSortButton(Builder<? extends AbstractSortButton> builder) {
        super(builder.x.intValue(), builder.y.intValue(), builder.width.intValue(), builder.height.intValue(), builder.buttonName);
        this.method_47400(class_7919.method_47407((class_2561)builder.buttonName));
        this.buttonName = builder.buttonName;
        this.shiftButtonName = builder.shiftButtonName;
        this.containerScreen = builder.containerScreen;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.x = builder.x;
        this.y = builder.y;
        this.xOffset = builder.xOffset;
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_48229(this.x, this.y);
        if (this.containerScreen instanceof class_490) {
            int leftPos = ((GuiPosition)this.containerScreen).nemosInventorySorting$getLeftPos();
            this.method_46421(leftPos + this.xOffset);
        }
        if (this.method_49606()) {
            guiGraphics.method_52706(this.getButtonHoverTexture(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        } else {
            guiGraphics.method_52706(this.getButtonTexture(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }
    }

    protected abstract class_2960 getButtonHoverTexture();

    protected abstract class_2960 getButtonTexture();

    public void setIsShiftKeyDown(boolean shiftKeyDown) {
        this.isShiftKeyDown = shiftKeyDown;
    }

    public void setTooltip(class_1703 menu) {
        if (this.isButtonShiftable(menu)) {
            this.method_47400(class_7919.method_47407((class_2561)this.shiftButtonName));
        } else {
            this.method_47400(class_7919.method_47407((class_2561)this.buttonName));
        }
    }

    protected int calculateEndIndex(class_1703 menu) {
        if (this.isButtonShiftable(menu)) {
            return this.endIndex + 9;
        }
        return this.endIndex;
    }

    private boolean isButtonShiftable(class_1703 menu) {
        return this.isShiftKeyDown && (this.startIndex != 0 || menu instanceof class_1723);
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public static class Builder<T extends AbstractSortButton> {
        private Integer startIndex;
        private Integer endIndex;
        private Integer x;
        private Integer y;
        private Integer xOffset;
        private Integer width;
        private Integer height;
        private class_2561 buttonName;
        private class_2561 shiftButtonName;
        private class_465<?> containerScreen;
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder<T> endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder<T> x(int x) {
            this.x = x;
            return this;
        }

        public Builder<T> y(int y) {
            this.y = y;
            return this;
        }

        public Builder<T> xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> buttonName(class_2561 buttonName) {
            this.buttonName = buttonName;
            return this;
        }

        public Builder<T> shiftButtonName(class_2561 shiftButtonName) {
            this.shiftButtonName = shiftButtonName;
            return this;
        }

        public Builder<T> containerScreen(class_465<?> containerScreen) {
            this.containerScreen = containerScreen;
            return this;
        }

        public T build() {
            this.checkRequiredFields();
            try {
                return (T)((Object)((AbstractSortButton)((Object)this.clazz.getDeclaredConstructor(Builder.class).newInstance(this))));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
            }
        }

        private void checkRequiredFields() {
            if (this.startIndex == null || this.endIndex == null || this.x == null || this.y == null || this.xOffset == null || this.width == null || this.height == null || this.buttonName == null || this.containerScreen == null) {
                throw new IllegalArgumentException("Not all fields were set!");
            }
        }
    }
}

